/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.workbook;

import bad.robot.excel.cell.BlankCell;
import bad.robot.excel.cell.BooleanCell;
import bad.robot.excel.cell.Cell;
import bad.robot.excel.cell.DateCell;
import bad.robot.excel.cell.DoubleCell;
import bad.robot.excel.cell.Formula;
import bad.robot.excel.cell.FormulaCell;
import bad.robot.excel.cell.Hyperlink;
import bad.robot.excel.cell.HyperlinkCell;
import bad.robot.excel.cell.StringCell;
import bad.robot.excel.row.CopyRow;
import bad.robot.excel.row.Row;
import bad.robot.excel.row.RowIndex;
import bad.robot.excel.sheet.Coordinate;
import bad.robot.excel.sheet.SheetIndex;
import bad.robot.excel.workbook.Editable;
import bad.robot.excel.workbook.PoiWorkbookReader;
import bad.robot.excel.workbook.WorkbookType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;

public class PoiWorkbook
implements Editable {
    private final Workbook workbook;

    public PoiWorkbook(WorkbookType type) {
        this.workbook = type.create();
        this.insertSheet("Sheet1");
    }

    public PoiWorkbook(InputStream stream) throws IOException {
        this.workbook = new PoiWorkbookReader().read(stream);
    }

    public PoiWorkbook(File file) throws IOException {
        this.workbook = new PoiWorkbookReader().read(file);
    }

    public PoiWorkbook(Workbook workbook) {
        if (workbook == null) {
            throw new IllegalArgumentException();
        }
        this.workbook = workbook;
    }

    @Override
    public PoiWorkbook blankCell(Coordinate coordinate) {
        new BlankCell().update(this.getCellForCoordinate(coordinate), this.workbook);
        return this;
    }

    @Override
    public PoiWorkbook replaceCell(Coordinate coordinate, Cell cell) {
        cell.update(this.getCellForCoordinate(coordinate), this.workbook);
        return this;
    }

    @Override
    public PoiWorkbook replaceCell(Coordinate coordinate, String text) {
        return this.replaceCell(coordinate, new StringCell(text));
    }

    @Override
    public PoiWorkbook replaceCell(Coordinate coordinate, Formula formula) {
        return this.replaceCell(coordinate, new FormulaCell(formula));
    }

    @Override
    public PoiWorkbook replaceCell(Coordinate coordinate, Date date) {
        return this.replaceCell(coordinate, new DateCell(date));
    }

    @Override
    public PoiWorkbook replaceCell(Coordinate coordinate, Double number) {
        return this.replaceCell(coordinate, new DoubleCell(number));
    }

    @Override
    public PoiWorkbook replaceCell(Coordinate coordinate, Hyperlink hyperlink) {
        return this.replaceCell(coordinate, new HyperlinkCell(hyperlink));
    }

    @Override
    public PoiWorkbook replaceCell(Coordinate coordinate, Boolean value) {
        return this.replaceCell(coordinate, new BooleanCell(value));
    }

    @Override
    public PoiWorkbook copyRow(Workbook workbook, Sheet worksheet, RowIndex from, RowIndex to) {
        CopyRow.copyRow(workbook, worksheet, from, to);
        return this;
    }

    @Override
    public Editable insertSheet(String name) {
        this.workbook.createSheet(WorkbookUtil.createSafeSheetName((String)name));
        return this;
    }

    @Override
    public Editable insertSheet() {
        this.workbook.createSheet();
        return this;
    }

    @Override
    public PoiWorkbook insertRowToFirstSheet(Row row, RowIndex index) {
        row.insertAt(this.workbook, SheetIndex.sheet(1), index);
        return this;
    }

    @Override
    public PoiWorkbook insertRowToSheet(Row row, RowIndex index, SheetIndex sheet) {
        row.insertAt(this.workbook, sheet, index);
        return this;
    }

    @Override
    public PoiWorkbook appendRowToFirstSheet(Row row) {
        row.appendTo(this.workbook, SheetIndex.sheet(1));
        return this;
    }

    @Override
    public PoiWorkbook appendRowToSheet(Row row, SheetIndex index) {
        row.appendTo(this.workbook, index);
        return this;
    }

    @Override
    public PoiWorkbook refreshFormulas() {
        HSSFFormulaEvaluator.evaluateAllFormulaCells((Workbook)this.workbook);
        return this;
    }

    private org.apache.poi.ss.usermodel.Cell getCellForCoordinate(Coordinate coordinate) {
        org.apache.poi.ss.usermodel.Row row = this.getRowForCoordinate(coordinate);
        return row.getCell(((Integer)coordinate.getColumn().value()).intValue(), org.apache.poi.ss.usermodel.Row.CREATE_NULL_AS_BLANK);
    }

    private org.apache.poi.ss.usermodel.Row getRowForCoordinate(Coordinate coordinate) {
        Sheet sheet = this.workbook.getSheetAt(((Integer)coordinate.getSheet().value()).intValue());
        org.apache.poi.ss.usermodel.Row row = sheet.getRow(((Integer)coordinate.getRow().value()).intValue());
        if (row == null) {
            row = sheet.createRow(((Integer)coordinate.getRow().value()).intValue());
        }
        return row;
    }

    public Workbook workbook() {
        return this.workbook;
    }
}

