/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.style;

import bad.robot.excel.cell.DataFormat;
import bad.robot.excel.style.Alignment;
import bad.robot.excel.style.Border;
import bad.robot.excel.style.Colour;
import bad.robot.excel.style.Fill;
import bad.robot.excel.style.FontColour;
import bad.robot.excel.style.FontSize;
import bad.robot.excel.style.ReplaceExistingStyle;
import bad.robot.excel.style.Style;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;

public class StyleBuilder
implements Style {
    private DataFormat format;
    private Alignment alignment;
    private FontSize fontSize;
    private Border border;
    private Fill fill;
    private FontColour fontColour = FontColour.fontColour(Colour.Black);

    private StyleBuilder() {
    }

    public static StyleBuilder aStyle() {
        return new StyleBuilder();
    }

    public StyleBuilder with(DataFormat format) {
        this.format = format;
        return this;
    }

    public StyleBuilder with(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public StyleBuilder with(FontSize fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public StyleBuilder with(FontColour fontColour) {
        this.fontColour = fontColour;
        return this;
    }

    public StyleBuilder with(Border border) {
        this.border = border;
        return this;
    }

    public StyleBuilder with(Fill fill) {
        this.fill = fill;
        return this;
    }

    private ReplaceExistingStyle build() {
        return new ReplaceExistingStyle(this.border, this.format, this.alignment, this.fontSize, this.fontColour, this.fill);
    }

    @Override
    public void applyTo(Cell cell, Workbook workbook) {
        this.build().applyTo(cell, workbook);
    }
}

