/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.row;

import bad.robot.excel.cell.BlankCell;
import bad.robot.excel.cell.Cell;
import bad.robot.excel.cell.DateCell;
import bad.robot.excel.cell.DoubleCell;
import bad.robot.excel.cell.StringCell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.column.ExcelColumnIndex;
import bad.robot.excel.row.Row;
import bad.robot.excel.row.RowBuilder;
import bad.robot.excel.style.Style;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class NullSkippingRowBuilder
implements RowBuilder {
    private final Map<ColumnIndex, Cell> cells;
    private final Style defaultStyle;

    public NullSkippingRowBuilder(int initialCapacity, Style defaultStyle) {
        this.cells = new HashMap<ColumnIndex, Cell>(initialCapacity);
        this.defaultStyle = defaultStyle;
        for (int i = 0; i < initialCapacity; ++i) {
            this.cells.put(ColumnIndex.column(ExcelColumnIndex.from(i)), new BlankCell(defaultStyle));
        }
    }

    @Override
    public RowBuilder withBlank(ColumnIndex index) {
        this.cells.put(index, new BlankCell(this.defaultStyle));
        return this;
    }

    @Override
    public NullSkippingRowBuilder withString(ColumnIndex index, String text) {
        if (text != null) {
            this.cells.put(index, new StringCell(text, this.defaultStyle));
        }
        return this;
    }

    @Override
    public NullSkippingRowBuilder withDouble(ColumnIndex index, Double value) {
        if (value != null) {
            this.cells.put(index, new DoubleCell(value, this.defaultStyle));
        }
        return this;
    }

    @Override
    public NullSkippingRowBuilder withInteger(ColumnIndex index, Integer value) {
        if (value != null) {
            this.cells.put(index, new DoubleCell(new Double(Integer.toString(value)), this.defaultStyle));
        }
        return this;
    }

    @Override
    public NullSkippingRowBuilder withDate(ColumnIndex index, Date date) {
        if (date != null) {
            this.cells.put(index, new DateCell(date, this.defaultStyle));
        }
        return this;
    }

    @Override
    public RowBuilder withFormula(ColumnIndex index, String formula) {
        if (formula != null) {
            this.cells.put(index, new StringCell(formula, this.defaultStyle));
        }
        return this;
    }

    @Override
    public Row build() {
        return new Row(this.cells);
    }
}

