/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.row;

import bad.robot.excel.cell.BlankCell;
import bad.robot.excel.cell.Cell;
import bad.robot.excel.cell.DateCell;
import bad.robot.excel.cell.DoubleCell;
import bad.robot.excel.cell.FormulaCell;
import bad.robot.excel.cell.StringCell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.row.Row;
import bad.robot.excel.row.RowBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DefaultRowBuilder
implements RowBuilder {
    private Map<ColumnIndex, Cell> cells = new HashMap<ColumnIndex, Cell>();

    private DefaultRowBuilder() {
    }

    public static RowBuilder aRow() {
        return new DefaultRowBuilder();
    }

    @Override
    public RowBuilder withBlank(ColumnIndex index) {
        this.cells.put(index, new BlankCell());
        return this;
    }

    @Override
    public RowBuilder withString(ColumnIndex index, String text) {
        this.cells.put(index, new StringCell(text));
        return this;
    }

    @Override
    public RowBuilder withDouble(ColumnIndex index, Double value) {
        this.cells.put(index, new DoubleCell(value));
        return this;
    }

    @Override
    public RowBuilder withInteger(ColumnIndex index, Integer value) {
        this.cells.put(index, new DoubleCell(new Double(Integer.toString(value))));
        return this;
    }

    @Override
    public RowBuilder withDate(ColumnIndex index, Date date) {
        this.cells.put(index, new DateCell(date));
        return this;
    }

    @Override
    public RowBuilder withFormula(ColumnIndex index, String formula) {
        this.cells.put(index, new FormulaCell(formula));
        return this;
    }

    @Override
    public Row build() {
        return new Row(this.cells);
    }
}

