/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.row;

import bad.robot.excel.row.RowIndex;
import bad.robot.excel.style.ClonedStyleFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class CopyRow {
    public static void copyRow(Workbook workbook, Sheet worksheet, RowIndex from, RowIndex to) {
        Row sourceRow = worksheet.getRow(((Integer)from.value()).intValue());
        Row newRow = worksheet.getRow(((Integer)to.value()).intValue());
        if (CopyRow.alreadyExists(newRow)) {
            worksheet.shiftRows(((Integer)to.value()).intValue(), worksheet.getLastRowNum(), 1);
        } else {
            newRow = worksheet.createRow(((Integer)to.value()).intValue());
        }
        for (int i = 0; i < sourceRow.getLastCellNum(); ++i) {
            Cell oldCell = sourceRow.getCell(i);
            Cell newCell = newRow.createCell(i);
            if (oldCell == null) continue;
            CopyRow.copyCellStyle(workbook, oldCell, newCell);
            CopyRow.copyCellComment(oldCell, newCell);
            CopyRow.copyCellHyperlink(oldCell, newCell);
            CopyRow.copyCellDataTypeAndValue(oldCell, newCell);
        }
        CopyRow.copyAnyMergedRegions(worksheet, sourceRow, newRow);
    }

    private static void copyCellStyle(Workbook workbook, Cell oldCell, Cell newCell) {
        newCell.setCellStyle(ClonedStyleFactory.newStyleBasedOn(oldCell).create(workbook));
    }

    private static void copyCellComment(Cell oldCell, Cell newCell) {
        if (newCell.getCellComment() != null) {
            newCell.setCellComment(oldCell.getCellComment());
        }
    }

    private static void copyCellHyperlink(Cell oldCell, Cell newCell) {
        if (oldCell.getHyperlink() != null) {
            newCell.setHyperlink(oldCell.getHyperlink());
        }
    }

    private static void copyCellDataTypeAndValue(Cell oldCell, Cell newCell) {
        CopyRow.setCellDataType(oldCell, newCell);
        CopyRow.setCellDataValue(oldCell, newCell);
    }

    private static void setCellDataType(Cell oldCell, Cell newCell) {
        newCell.setCellType(oldCell.getCellType());
    }

    private static void setCellDataValue(Cell oldCell, Cell newCell) {
        switch (oldCell.getCellType()) {
            case 3: {
                newCell.setCellValue(oldCell.getStringCellValue());
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case 2: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 1: {
                newCell.setCellValue(oldCell.getRichStringCellValue());
            }
        }
    }

    private static boolean alreadyExists(Row newRow) {
        return newRow != null;
    }

    private static void copyAnyMergedRegions(Sheet worksheet, Row sourceRow, Row newRow) {
        for (int i = 0; i < worksheet.getNumMergedRegions(); ++i) {
            CopyRow.copyMergeRegion(worksheet, sourceRow, newRow, worksheet.getMergedRegion(i));
        }
    }

    private static void copyMergeRegion(Sheet worksheet, Row sourceRow, Row newRow, CellRangeAddress mergedRegion) {
        CellRangeAddress range = mergedRegion;
        if (range.getFirstRow() == sourceRow.getRowNum()) {
            int lastRow = newRow.getRowNum() + (range.getLastRow() - range.getFirstRow());
            CellRangeAddress newCellRangeAddress = new CellRangeAddress(newRow.getRowNum(), lastRow, range.getFirstColumn(), range.getLastColumn());
            worksheet.addMergedRegion(newCellRangeAddress);
        }
    }
}

