/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.matchers.RowNumberMatcher;
import bad.robot.excel.matchers.RowsMatcher;
import bad.robot.excel.sheet.SheetIterable;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class SheetsMatcher
extends TypeSafeDiagnosingMatcher<Workbook> {
    private final Workbook expected;

    public SheetsMatcher(Workbook expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(Workbook actual, Description mismatch) {
        for (Sheet expectedSheet : SheetIterable.sheetsOf(this.expected)) {
            Sheet actualSheet = actual.getSheet(expectedSheet.getSheetName());
            if (!RowNumberMatcher.hasSameNumberOfRowAs(expectedSheet).matchesSafely(actualSheet, mismatch)) {
                return false;
            }
            if (RowsMatcher.hasSameRowsAs(expectedSheet).matchesSafely(actualSheet, mismatch)) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("equality on all sheets in workbook");
    }
}

