/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import org.apache.poi.ss.usermodel.Workbook;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class SheetNumberMatcher
extends TypeSafeDiagnosingMatcher<Workbook> {
    private final Workbook expected;

    private SheetNumberMatcher(Workbook expected) {
        this.expected = expected;
    }

    public static SheetNumberMatcher hasSameNumberOfSheetsAs(Workbook expected) {
        return new SheetNumberMatcher(expected);
    }

    protected boolean matchesSafely(Workbook actual, Description mismatch) {
        if (this.expected.getNumberOfSheets() != actual.getNumberOfSheets()) {
            mismatch.appendText("got ").appendValue((Object)actual.getNumberOfSheets()).appendText(" sheet(s) expected ").appendValue((Object)this.expected.getNumberOfSheets());
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.expected.getNumberOfSheets()).appendText(" sheet(s)");
    }
}

