/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.sheet.SheetIterable;
import bad.robot.excel.sheet.SheetNameIterable;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class SheetNameMatcher
extends TypeSafeDiagnosingMatcher<Workbook> {
    private final Workbook expected;

    private SheetNameMatcher(Workbook expected) {
        this.expected = expected;
    }

    public static SheetNameMatcher containsSameNamedSheetsAs(Workbook expected) {
        return new SheetNameMatcher(expected);
    }

    protected boolean matchesSafely(Workbook actual, Description mismatch) {
        ArrayList<String> missingSheets = new ArrayList<String>();
        for (Sheet sheet : SheetIterable.sheetsOf(this.expected)) {
            if (actual.getSheet(sheet.getSheetName()) != null) continue;
            missingSheets.add(sheet.getSheetName());
        }
        mismatch.appendValueList("sheet(s) ", ", ", SheetNameMatcher.notFound(missingSheets), missingSheets);
        return missingSheets.isEmpty();
    }

    public void describeTo(Description description) {
        if (!SheetNameMatcher.anyPreviousDescriptionsIncludedIn(description)) {
            description.appendText("workbook to contain sheets ");
        }
        description.appendText("named ").appendValueList("", ", ", "", (Iterable)SheetNameIterable.sheetNamesOf(this.expected));
    }

    private static boolean anyPreviousDescriptionsIncludedIn(Description description) {
        return !description.toString().endsWith("Expected: ");
    }

    private static String notFound(List<String> values) {
        return String.format(" %s missing", values.size() == 1 ? "was" : "were");
    }
}

