/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import org.apache.poi.ss.usermodel.Sheet;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class RowNumberMatcher
extends TypeSafeDiagnosingMatcher<Sheet> {
    private final Sheet expected;

    public static RowNumberMatcher hasSameNumberOfRowAs(Sheet expected) {
        return new RowNumberMatcher(expected);
    }

    private RowNumberMatcher(Sheet expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(Sheet actual, Description mismatch) {
        if (this.expected.getLastRowNum() != actual.getLastRowNum()) {
            mismatch.appendText("got ").appendValue((Object)RowNumberMatcher.numberOfRowsIn(actual)).appendText(" row(s) in sheet ").appendValue((Object)actual.getSheetName()).appendText(" expected ").appendValue((Object)RowNumberMatcher.numberOfRowsIn(this.expected));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)RowNumberMatcher.numberOfRowsIn(this.expected)).appendText(" row(s) in sheet ").appendValue((Object)this.expected.getSheetName());
    }

    private static int numberOfRowsIn(Sheet sheet) {
        return sheet.getLastRowNum() + 1;
    }
}

