/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.PoiToExcelCoercions;
import bad.robot.excel.matchers.CellNumberMatcher;
import bad.robot.excel.matchers.CellsMatcher;
import bad.robot.excel.matchers.RowMissingMatcher;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class RowInSheetMatcher
extends TypeSafeDiagnosingMatcher<Sheet> {
    private final Row expected;
    private int rowIndex;

    public static RowInSheetMatcher hasSameRow(Row expected) {
        return new RowInSheetMatcher(expected);
    }

    private RowInSheetMatcher(Row expected) {
        this.expected = expected;
        this.rowIndex = expected.getRowNum();
    }

    protected boolean matchesSafely(Sheet actualSheet, Description mismatch) {
        Row actual = actualSheet.getRow(this.rowIndex);
        if (!RowMissingMatcher.rowIsPresent(this.expected).matchesSafely(actual, mismatch)) {
            return false;
        }
        if (!CellNumberMatcher.hasSameNumberOfCellsAs(this.expected).matchesSafely(actual, mismatch)) {
            return false;
        }
        return CellsMatcher.hasSameCellsAs(this.expected).matchesSafely(actual, mismatch);
    }

    public void describeTo(Description description) {
        description.appendText("equality of row ").appendValue((Object)PoiToExcelCoercions.asExcelRow(this.expected));
    }
}

