/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.PoiToExcelCoercions;
import bad.robot.excel.matchers.CellInRowMatcher;
import bad.robot.excel.matchers.CompositeMatcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class CellsMatcher
extends TypeSafeDiagnosingMatcher<Row> {
    private final Row expected;
    private final List<Matcher<Row>> cellsOnRow;

    public static CellsMatcher hasSameCellsAs(Row expected) {
        return new CellsMatcher(expected);
    }

    private CellsMatcher(Row expected) {
        this.expected = expected;
        this.cellsOnRow = CellsMatcher.createCellMatchers(expected);
    }

    protected boolean matchesSafely(Row actual, Description mismatch) {
        return CompositeMatcher.allOf(this.cellsOnRow).matchesSafely(actual, mismatch);
    }

    public void describeTo(Description description) {
        description.appendText("equality of all cells on row ").appendValue((Object)PoiToExcelCoercions.asExcelRow(this.expected));
    }

    private static List<Matcher<Row>> createCellMatchers(Row row) {
        ArrayList<Matcher<Row>> matchers = new ArrayList<Matcher<Row>>();
        for (Cell expected : row) {
            matchers.add((Matcher<Row>)CellInRowMatcher.hasSameCell(row.getSheet(), expected));
        }
        return matchers;
    }
}

