/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.matchers;

import bad.robot.excel.PoiToExcelCoercions;
import bad.robot.excel.cell.BlankCell;
import bad.robot.excel.cell.BooleanCell;
import bad.robot.excel.cell.Cell;
import bad.robot.excel.cell.DateCell;
import bad.robot.excel.cell.DoubleCell;
import bad.robot.excel.cell.ErrorCell;
import bad.robot.excel.cell.FormulaCell;
import bad.robot.excel.cell.Hyperlink;
import bad.robot.excel.cell.HyperlinkCell;
import bad.robot.excel.cell.StringCell;
import bad.robot.excel.matchers.CellAdapter;
import org.apache.poi.ss.usermodel.DateUtil;

public enum CellType implements CellAdapter
{
    Boolean(4){

        @Override
        public Cell adapt(org.apache.poi.ss.usermodel.Cell cell) {
            return new BooleanCell(cell.getBooleanCellValue());
        }
    }
    ,
    Error(5){

        @Override
        public Cell adapt(org.apache.poi.ss.usermodel.Cell cell) {
            return new ErrorCell(cell.getErrorCellValue());
        }
    }
    ,
    Formula(2){

        @Override
        public Cell adapt(org.apache.poi.ss.usermodel.Cell cell) {
            if (cell.getCachedFormulaResultType() == 5) {
                return new ErrorCell(cell.getErrorCellValue());
            }
            return new FormulaCell(cell.getCellFormula());
        }
    }
    ,
    Numeric(0){

        @Override
        public Cell adapt(org.apache.poi.ss.usermodel.Cell cell) {
            if (DateUtil.isCellDateFormatted((org.apache.poi.ss.usermodel.Cell)cell)) {
                return new DateCell(cell.getDateCellValue());
            }
            return new DoubleCell(cell.getNumericCellValue());
        }
    }
    ,
    String(1){

        @Override
        public Cell adapt(org.apache.poi.ss.usermodel.Cell cell) {
            if (cell.getHyperlink() != null && this.containsUrl(cell.getHyperlink())) {
                return new HyperlinkCell(Hyperlink.hyperlink(cell.getStringCellValue(), cell.getHyperlink().getAddress()));
            }
            if (cell.getStringCellValue() == null || "".equals(cell.getStringCellValue())) {
                return new BlankCell();
            }
            return new StringCell(cell.getStringCellValue());
        }

        private boolean containsUrl(org.apache.poi.ss.usermodel.Hyperlink hyperlink) {
            return hyperlink.getAddress().startsWith("http://") || hyperlink.getAddress().startsWith("file://");
        }
    }
    ,
    Blank(3){

        @Override
        public Cell adapt(org.apache.poi.ss.usermodel.Cell cell) {
            return new BlankCell();
        }
    };

    private final Integer poiType;

    private CellType(Integer poiType) {
        this.poiType = poiType;
    }

    private static CellAdapter getAdapterFor(org.apache.poi.ss.usermodel.Cell poi) {
        if (poi == null) {
            return Blank;
        }
        for (CellType type : CellType.values()) {
            if (type.poiType.intValue() != poi.getCellType()) continue;
            return type;
        }
        throw new RuntimeException("Unknown poi type " + poi.getCellType());
    }

    public static Cell adaptPoi(org.apache.poi.ss.usermodel.Cell cell) {
        try {
            return CellType.getAdapterFor(cell).adapt(cell);
        }
        catch (Exception e) {
            throw new IllegalStateException("problem with cell " + PoiToExcelCoercions.asExcelCoordinate(cell), e);
        }
    }
}

