/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.cell;

import bad.robot.excel.cell.StyledCell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.style.NoStyle;
import bad.robot.excel.style.Style;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class DoubleCell
extends StyledCell {
    private final Double number;

    public DoubleCell(Double number) {
        this(number, new NoStyle());
    }

    public DoubleCell(Double number, Style style) {
        super(style);
        this.number = number;
    }

    @Override
    public void addTo(Row row, ColumnIndex column, Workbook workbook) {
        Cell cell = row.createCell(((Integer)column.value()).intValue(), 0);
        this.update(cell, workbook);
    }

    @Override
    public void update(Cell cell, Workbook workbook) {
        this.getStyle().applyTo(cell, workbook);
        cell.setCellValue(this.number.doubleValue());
    }

    public String toString() {
        return String.format("%sD", this.number.toString());
    }
}

