/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.cell;

import bad.robot.excel.cell.DataFormat;
import bad.robot.excel.cell.StyledCell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.style.NoStyle;
import bad.robot.excel.style.Style;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class DateCell
extends StyledCell {
    private final Date date;

    public DateCell(Date date) {
        this(date, new NoStyle());
    }

    public DateCell(Date date, Style style) {
        super(style);
        this.date = date;
    }

    @Override
    public void addTo(Row row, ColumnIndex column, Workbook workbook) {
        Cell cell = row.createCell(((Integer)column.value()).intValue(), 0);
        this.update(cell, workbook);
    }

    @Override
    public void update(Cell cell, Workbook workbook) {
        this.getStyle().applyTo(cell, workbook);
        if (!DateCell.isCellDateFormatted(cell)) {
            this.overrideAsDateFormatting(workbook, cell);
        }
        cell.setCellValue(this.date);
    }

    private void overrideAsDateFormatting(Workbook workbook, Cell cell) {
        DataFormat.asDayMonthYear().applyTo(cell, workbook);
    }

    public String toString() {
        return this.date.toString();
    }

    private static boolean isCellDateFormatted(Cell cell) {
        return cell.getCellType() == 0 && DateUtil.isCellDateFormatted((Cell)cell);
    }
}

