/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.cell;

import bad.robot.excel.AbstractValueType;
import bad.robot.excel.style.ClonedStyleFactory;
import bad.robot.excel.style.Style;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public class DataFormat
extends AbstractValueType<String>
implements Style {
    public static DataFormat asDayMonthYear() {
        return DataFormat.dataFormat("dd-MMM-yyyy");
    }

    public static DataFormat asTwoDecimalPlacesNumber() {
        return DataFormat.dataFormat("#,##0.00");
    }

    public static DataFormat dataFormat(String value) {
        return new DataFormat(value);
    }

    private DataFormat(String value) {
        super(value);
    }

    @Override
    public void applyTo(Cell cell, Workbook workbook) {
        this.updateDataFormat(cell, workbook);
    }

    private void updateDataFormat(Cell cell, Workbook workbook) {
        CellStyle style = ClonedStyleFactory.newStyleBasedOn(cell).create(workbook);
        style.setDataFormat(workbook.createDataFormat().getFormat((String)this.value()));
        cell.setCellStyle(style);
    }
}

