/*
 * Decompiled with CFR 0.152.
 */
package bad.robot.excel.cell;

import bad.robot.excel.cell.StyledCell;
import bad.robot.excel.column.ColumnIndex;
import bad.robot.excel.style.NoStyle;
import bad.robot.excel.style.Style;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class BooleanCell
extends StyledCell {
    private final Boolean value;

    public BooleanCell(Boolean value) {
        this(value, new NoStyle());
    }

    public BooleanCell(Boolean value, Style style) {
        super(style);
        this.value = value;
    }

    @Override
    public void addTo(Row row, ColumnIndex column, Workbook workbook) {
        Cell cell = row.createCell(((Integer)column.value()).intValue(), 4);
        this.update(cell, workbook);
    }

    @Override
    public void update(Cell cell, Workbook workbook) {
        this.getStyle().applyTo(cell, workbook);
        cell.setCellValue(this.value.booleanValue());
    }

    public String toString() {
        return this.value.toString().toUpperCase();
    }
}

