/*
 * Copyright (c) 2012-2013, bad robot (london) ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package bad.robot.excel;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

import static bad.robot.excel.Assertions.assertNotNull;
import static org.apache.commons.lang3.builder.CompareToBuilder.reflectionCompare;
import static org.apache.commons.lang3.builder.ToStringStyle.SHORT_PREFIX_STYLE;

public abstract class AbstractValueType<T extends Serializable> implements ValueType<T>, Serializable, Comparable<AbstractValueType<?>> {

    private final T value;

    public AbstractValueType(T value) {
        assertNotNull(value);
        this.value = value;
    }

    @Override
    public T value() {
        return value;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(value()).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null)
            return false;
        if (other == this)
            return true;
        if (this.getClass().equals(other.getClass()))
            return new EqualsBuilder().append(value(), ((AbstractValueType) other).value()).isEquals();
        return false;
    }

    @Override
    public int compareTo(AbstractValueType<?> other) {
        return reflectionCompare(value(), other.value(), true);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, SHORT_PREFIX_STYLE).append(value()).toString();
    }

}
