/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.Path;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.AwareException;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.HttpResponseAware;
import si.mazi.rescu.HttpTemplate;
import si.mazi.rescu.InvocationAware;
import si.mazi.rescu.InvocationResult;
import si.mazi.rescu.RequestWriter;
import si.mazi.rescu.RequestWriterResolver;
import si.mazi.rescu.ResponseReaderResolver;
import si.mazi.rescu.RestInvocation;
import si.mazi.rescu.RestMethodMetadata;
import si.mazi.rescu.SynchronizedValueFactory;
import si.mazi.rescu.clients.HttpConnection;
import si.mazi.rescu.serialization.PlainTextResponseReader;
import si.mazi.rescu.serialization.jackson.DefaultJacksonObjectMapperFactory;
import si.mazi.rescu.serialization.jackson.JacksonObjectMapperFactory;
import si.mazi.rescu.serialization.jackson.JacksonResponseReader;

public class RestInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RestInvocationHandler.class);
    private final ResponseReaderResolver responseReaderResolver;
    private final RequestWriterResolver requestWriterResolver;
    private final HttpTemplate httpTemplate;
    private final String intfacePath;
    private final String baseUrl;
    private final ClientConfig config;
    private final Map<Method, RestMethodMetadata> methodMetadataCache = new HashMap<Method, RestMethodMetadata>();

    RestInvocationHandler(Class<?> restInterface, String url, ClientConfig config) {
        this.intfacePath = restInterface.getAnnotation(Path.class).value();
        this.baseUrl = url;
        if (config == null) {
            config = new ClientConfig();
        }
        this.config = config;
        JacksonObjectMapperFactory mapperFactory = config.getJacksonObjectMapperFactory();
        if (mapperFactory == null) {
            mapperFactory = new DefaultJacksonObjectMapperFactory();
        }
        ObjectMapper mapper = mapperFactory.createObjectMapper();
        this.requestWriterResolver = RequestWriterResolver.createDefault(mapper);
        this.responseReaderResolver = new ResponseReaderResolver();
        this.responseReaderResolver.addReader("application/json", new JacksonResponseReader(mapper, this.config.isIgnoreHttpErrorCodes()));
        this.responseReaderResolver.addReader("text/plain", new PlainTextResponseReader(this.config.isIgnoreHttpErrorCodes()));
        this.httpTemplate = new HttpTemplate(this.config.getHttpConnTimeout(), this.config.getHttpReadTimeout(), this.config.getProxyHost(), this.config.getProxyPort(), this.config.getProxyType(), this.config.getSslSocketFactory(), this.config.getHostnameVerifier(), this.config.getOAuthConsumer(), this.config.getConnectionType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        RestMethodMetadata methodMetadata = this.getMetadata(method);
        Closeable connection = null;
        RestInvocation invocation = null;
        Object lock = RestInvocationHandler.getValueGenerator(args);
        if (lock == null) {
            lock = new Object();
        }
        try {
            SynchronizedValueFactory synchronizedValueFactory = lock;
            synchronized (synchronizedValueFactory) {
                invocation = this.createInvocation(method, args);
                connection = this.invokeHttp(invocation);
            }
            Object result = this.receiveAndMap(methodMetadata, (HttpConnection)connection);
            this.makeAware(result, (HttpConnection)connection, invocation);
            Object object = result;
            return object;
        }
        catch (Exception e) {
            boolean madeAware = this.makeAware(e, (HttpConnection)connection, invocation);
            if (this.config.isWrapUnexpectedExceptions() && !madeAware) {
                throw new AwareException(e, invocation);
            }
            throw e;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private boolean makeAware(Object result, HttpConnection connection, RestInvocation invocation) {
        boolean madeAware = false;
        if (result instanceof InvocationAware) {
            try {
                ((InvocationAware)result).setInvocation(invocation);
                madeAware = true;
            }
            catch (Exception ex) {
                log.warn("Failed to set invocation on the InvocationAware", (Throwable)ex);
            }
        }
        if (result instanceof HttpResponseAware && connection != null) {
            try {
                ((HttpResponseAware)result).setResponseHeaders(connection.getHeaderFields());
                madeAware = true;
            }
            catch (Exception ex) {
                log.warn("Failed to set response headers on the HttpResponseAware", (Throwable)ex);
            }
        }
        return madeAware;
    }

    protected HttpConnection invokeHttp(RestInvocation invocation) throws IOException {
        RestMethodMetadata methodMetadata = invocation.getMethodMetadata();
        RequestWriter requestWriter = this.requestWriterResolver.resolveWriter(invocation.getMethodMetadata());
        String requestBody = requestWriter.writeBody(invocation);
        return this.httpTemplate.send(invocation.getInvocationUrl(), requestBody, invocation.getAllHttpHeaders(), methodMetadata.getHttpMethod());
    }

    protected Object receiveAndMap(RestMethodMetadata methodMetadata, HttpConnection connection) throws IOException {
        InvocationResult invocationResult = this.httpTemplate.receive(connection);
        return this.mapInvocationResult(invocationResult, methodMetadata);
    }

    private static SynchronizedValueFactory getValueGenerator(Object[] args) {
        if (args != null) {
            for (Object arg : args) {
                if (!(arg instanceof SynchronizedValueFactory)) continue;
                return (SynchronizedValueFactory)arg;
            }
        }
        return null;
    }

    protected Object mapInvocationResult(InvocationResult invocationResult, RestMethodMetadata methodMetadata) throws IOException {
        return this.responseReaderResolver.resolveReader(methodMetadata).read(invocationResult, methodMetadata);
    }

    private RestMethodMetadata getMetadata(Method method) {
        RestMethodMetadata metadata = this.methodMetadataCache.get(method);
        if (metadata == null) {
            metadata = RestMethodMetadata.create(method, this.baseUrl, this.intfacePath);
            this.methodMetadataCache.put(method, metadata);
        }
        return metadata;
    }

    protected RestInvocation createInvocation(Method method, Object[] args) {
        return RestInvocation.create(this.requestWriterResolver, this.getMetadata(method), args, this.config.getDefaultParamsMap());
    }
}

