/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import si.mazi.rescu.FormUrlEncodedRequestWriter;
import si.mazi.rescu.RequestWriter;
import si.mazi.rescu.RestMethodMetadata;
import si.mazi.rescu.serialization.ToStringRequestWriter;
import si.mazi.rescu.serialization.jackson.JacksonRequestWriter;

public class RequestWriterResolver {
    protected final HashMap<String, RequestWriter> writers = new HashMap();

    public static RequestWriterResolver createDefault(ObjectMapper mapper) {
        RequestWriterResolver requestWriterResolver = new RequestWriterResolver();
        requestWriterResolver.addWriter("application/x-www-form-urlencoded", new FormUrlEncodedRequestWriter());
        requestWriterResolver.addWriter("application/json", new JacksonRequestWriter(mapper));
        requestWriterResolver.addWriter("text/plain", new ToStringRequestWriter());
        return requestWriterResolver;
    }

    public void addWriter(String mediaType, RequestWriter writer) {
        this.writers.put(mediaType, writer);
    }

    public RequestWriter resolveWriter(RestMethodMetadata methodMetadata) {
        RequestWriter writer;
        String reqContentType = methodMetadata.getReqContentType();
        if (reqContentType == null) {
            reqContentType = "application/x-www-form-urlencoded";
        }
        if ((writer = this.writers.get(reqContentType)) == null) {
            throw new IllegalArgumentException("Unsupported media type: " + reqContentType);
        }
        return writer;
    }
}

