/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;
import si.mazi.rescu.SynchronizedValueFactory;

public final class Params
implements Serializable {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();
    private final DateFormat iso8601datetime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final DateFormat iso8601date;

    private Params() {
        this.iso8601datetime.setTimeZone(UTC);
        this.iso8601date = new SimpleDateFormat("yyyy-MM-dd");
        this.iso8601date.setTimeZone(UTC);
    }

    private Params(Map<String, Object> data) {
        this.iso8601datetime.setTimeZone(UTC);
        this.iso8601date = new SimpleDateFormat("yyyy-MM-dd");
        this.iso8601date.setTimeZone(UTC);
        this.data.putAll(data);
    }

    public static Params of() {
        return new Params();
    }

    public static Params of(String param, Object value) {
        return Params.of().add(param, value);
    }

    public static Params of(String p1, Object v1, String p2, Object v2) {
        return Params.of(p1, v1).add(p2, v2);
    }

    public static Params of(String p1, Object v1, String p2, Object v2, String p3, Object v3) {
        return Params.of(p1, v1, p2, v2).add(p3, v3);
    }

    public static Params of(String p1, Object v1, String p2, Object v2, String p3, Object v3, String p4, Object v4) {
        return Params.of(p1, v1, p2, v2, p3, v3).add(p4, v4);
    }

    public Params add(String param, Object value) {
        this.data.put(param, value);
        return this;
    }

    private String toQueryString(boolean encode) {
        StringBuilder b = new StringBuilder();
        for (String paramName : this.data.keySet()) {
            if (!this.isParamSet(paramName)) continue;
            Object originalValue = this.getParamValue(paramName);
            boolean createArrayParameters = originalValue instanceof Iterable && paramName.endsWith("[]");
            Set<Object> paramValues = createArrayParameters ? (Set<Object>)originalValue : Collections.singleton(originalValue);
            for (Object t : paramValues) {
                if (b.length() > 0) {
                    b.append('&');
                }
                String paramValueAsString = this.toString(t);
                b.append(paramName).append('=').append(this.urlEncode(paramValueAsString, encode));
            }
        }
        return b.toString();
    }

    private String urlEncode(String data, boolean encode) {
        try {
            return encode ? URLEncoder.encode(data, "UTF-8") : data;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Illegal encoding, fix the code.", e);
        }
    }

    public String asQueryString() {
        return this.toQueryString(true);
    }

    public String asFormEncodedRequestBody() {
        return this.toQueryString(true);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String applyToPath(String path) {
        for (String paramName : this.data.keySet()) {
            if (!this.isParamSet(paramName)) {
                throw new IllegalArgumentException("The value of '" + paramName + "' path parameter was not specified.");
            }
            path = Pattern.compile("\\{" + paramName + "(:.+?)?\\}").matcher(path).replaceAll(Matcher.quoteReplacement(this.urlEncode(this.getParamValueAsString(paramName), true)));
        }
        return path;
    }

    public Map<String, String> asHttpHeaders() {
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
        for (String key : this.data.keySet()) {
            if (!this.isParamSet(key)) continue;
            stringMap.put(key, this.getParamValueAsString(key));
        }
        return stringMap;
    }

    private String getParamValueAsString(String key) {
        Object paramValue = this.getParamValue(key);
        return this.toString(paramValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toString(Object paramValue) {
        if (paramValue instanceof BigDecimal) {
            return ((BigDecimal)paramValue).toPlainString();
        }
        if (paramValue instanceof Iterable) {
            return this.iterableToString((Iterable)paramValue);
        }
        if (paramValue instanceof Date) {
            DateFormat dateFormat = this.iso8601date;
            synchronized (dateFormat) {
                return this.iso8601date.format(paramValue);
            }
        }
        if (paramValue instanceof java.util.Date) {
            DateFormat dateFormat = this.iso8601datetime;
            synchronized (dateFormat) {
                return this.iso8601datetime.format(paramValue);
            }
        }
        return String.valueOf(paramValue);
    }

    String iterableToString(Iterable iterable) {
        StringBuilder sb = new StringBuilder();
        for (Object o : iterable) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.toString(o));
        }
        return sb.toString();
    }

    public void digestAll(RestInvocation invocationParams) {
        for (String paramName : this.data.keySet()) {
            Object paramValue = this.getParamValue(paramName);
            if (!(paramValue instanceof ParamsDigest)) continue;
            this.data.put(paramName, ((ParamsDigest)paramValue).digestParams(invocationParams));
        }
    }

    public boolean isParamSet(String paramName) {
        return this.data.containsKey(paramName) && this.getParamValue(paramName) != null;
    }

    public Object getParamValue(String paramName) {
        return this.data.get(paramName);
    }

    public void replaceValueFactories() {
        for (Map.Entry<String, Object> e : this.data.entrySet()) {
            Object value = e.getValue();
            if (!(value instanceof SynchronizedValueFactory)) continue;
            e.setValue(((SynchronizedValueFactory)value).createValue());
        }
    }

    public String toString() {
        return this.toQueryString(false);
    }

    public Params copy() {
        return new Params(this.data);
    }
}

