/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthException;
import oauth.signpost.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.HttpMethod;
import si.mazi.rescu.InvocationResult;
import si.mazi.rescu.clients.ApacheConnection;
import si.mazi.rescu.clients.HttpConnection;
import si.mazi.rescu.clients.HttpConnectionType;
import si.mazi.rescu.clients.JavaConnection;
import si.mazi.rescu.oauth.RescuOAuthRequestAdapter;
import si.mazi.rescu.utils.HttpUtils;

class HttpTemplate {
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static int responseMaxLogLen = 4096;
    public static int requestMaxLogLen = 4096;
    private final Logger log = LoggerFactory.getLogger(HttpTemplate.class);
    private final Map<String, String> defaultHttpHeaders = new HashMap<String, String>();
    private final int connTimeout;
    private final int readTimeout;
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final OAuthConsumer oAuthConsumer;
    private final HttpConnectionType connectionType;

    HttpTemplate(int readTimeout, String proxyHost, Integer proxyPort, Proxy.Type proxyType, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, OAuthConsumer oAuthConsumer, HttpConnectionType connectionType) {
        this(0, readTimeout, proxyHost, proxyPort, proxyType, sslSocketFactory, hostnameVerifier, oAuthConsumer, connectionType);
    }

    HttpTemplate(int connTimeout, int readTimeout, String proxyHost, Integer proxyPort, Proxy.Type proxyType, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, OAuthConsumer oAuthConsumer, HttpConnectionType connectionType) {
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.oAuthConsumer = oAuthConsumer;
        this.connectionType = connectionType;
        this.defaultHttpHeaders.put("Accept-Charset", CHARSET_UTF_8);
        this.defaultHttpHeaders.put("Accept", "application/json");
        this.defaultHttpHeaders.put("Accept-Encoding", "gzip");
        this.defaultHttpHeaders.put("User-Agent", "ResCU JDK/6 AppleWebKit/535.7 Chrome/16.0.912.36 Safari/535.7");
        if (proxyHost == null || proxyPort == null) {
            this.proxy = Proxy.NO_PROXY;
        } else {
            Proxy.Type type = proxyType == null ? Proxy.Type.HTTP : proxyType;
            this.proxy = new Proxy(type, new InetSocketAddress(proxyHost, (int)proxyPort));
            this.log.info("Using proxy {}", (Object)this.proxy);
        }
    }

    HttpConnection send(String urlString, String requestBody, Map<String, String> httpHeaders, HttpMethod method) throws IOException {
        if (requestBody != null && requestBody.length() > 0) {
            this.log.debug("Executing {} request at {}  body \n{}", new Object[]{method, urlString, this.truncate(requestBody, requestMaxLogLen)});
        } else {
            this.log.debug("Executing {} request at {}", (Object)method, (Object)urlString);
        }
        this.log.trace("Request headers = {}", httpHeaders);
        HttpTemplate.preconditionNotNull(urlString, "urlString cannot be null");
        HttpTemplate.preconditionNotNull(httpHeaders, "httpHeaders should not be null");
        int contentLength = requestBody == null ? 0 : requestBody.getBytes().length;
        HttpConnection connection = this.configureURLConnection(method, urlString, httpHeaders, contentLength);
        if (this.oAuthConsumer != null) {
            if (connection.getHttpConnectionType() != HttpConnectionType.java) {
                throw new RuntimeException("OAuth not supported yet for " + (Object)((Object)connection.getHttpConnectionType()));
            }
            JavaConnection jc = (JavaConnection)connection;
            RescuOAuthRequestAdapter request = new RescuOAuthRequestAdapter(jc.getHttpURLConnection(), requestBody);
            try {
                this.oAuthConsumer.sign((HttpRequest)request);
            }
            catch (OAuthException e) {
                throw new RuntimeException("OAuth error", e);
            }
        }
        if (contentLength > 0) {
            OutputStream out = connection.getOutputStream();
            out.write(requestBody.getBytes(CHARSET_UTF_8));
            out.flush();
        }
        return connection;
    }

    InvocationResult receive(HttpConnection connection) throws IOException {
        InputStream inputStream;
        String responseString;
        int httpStatus = connection.getResponseCode();
        this.log.debug("Request http status = {}", (Object)httpStatus);
        if (this.log.isTraceEnabled()) {
            for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
                if (entry.getKey() == null) continue;
                this.log.trace("Header response property: key='{}', value='{}'", (Object)entry.getKey(), entry.getValue());
            }
        }
        if ((responseString = this.readInputStreamAsEncodedString(inputStream = !HttpUtils.isErrorStatusCode(httpStatus) ? connection.getInputStream() : connection.getErrorStream(), connection)) != null && responseString.startsWith("\ufeff")) {
            responseString = responseString.substring(1);
        }
        this.log.debug("Http call returned {}; response body:\n{}", (Object)httpStatus, (Object)this.truncate(responseString, responseMaxLogLen));
        return new InvocationResult(responseString, httpStatus);
    }

    private HttpConnection configureURLConnection(HttpMethod method, String urlString, Map<String, String> httpHeaders, int contentLength) throws IOException {
        HttpTemplate.preconditionNotNull((Object)method, "method cannot be null");
        HttpTemplate.preconditionNotNull(urlString, "urlString cannot be null");
        HttpTemplate.preconditionNotNull(httpHeaders, "httpHeaders cannot be null");
        HttpConnection connection = this.getRescuHttpURLConnection(urlString);
        connection.setRequestMethod(method);
        HashMap<String, String> headerKeyValues = new HashMap<String, String>(this.defaultHttpHeaders);
        headerKeyValues.putAll(httpHeaders);
        for (Map.Entry entry : headerKeyValues.entrySet()) {
            connection.setHeader((String)entry.getKey(), (String)entry.getValue());
            this.log.trace("Header request property: key='{}', value='{}'", entry.getKey(), entry.getValue());
        }
        connection.doFinalConfig(contentLength);
        connection.setHeader("Content-Length", Integer.toString(contentLength));
        return connection;
    }

    protected HttpConnection getRescuHttpURLConnection(String urlString) throws IOException {
        HttpConnection connection = null;
        switch (this.connectionType) {
            case java: {
                connection = JavaConnection.create(urlString, this.proxy);
                break;
            }
            case apache: {
                connection = ApacheConnection.create(urlString, this.proxy);
                break;
            }
            default: {
                throw new RuntimeException("Not supported connection type " + (Object)((Object)this.connectionType));
            }
        }
        if (this.readTimeout > 0) {
            connection.setReadTimeout(this.readTimeout);
        }
        if (this.connTimeout > 0) {
            connection.setConnectTimeout(this.connTimeout);
        }
        if (connection.isSsl()) {
            if (this.sslSocketFactory != null) {
                connection.setSSLSocketFactory(this.sslSocketFactory);
            }
            if (this.hostnameVerifier != null) {
                connection.setHostnameVerifier(this.hostnameVerifier);
            }
        }
        return connection;
    }

    /*
     * Exception decompiling
     */
    String readInputStreamAsEncodedString(InputStream inputStream, HttpConnection connection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean izGzipped(HttpConnection connection) {
        return "gzip".equalsIgnoreCase(connection.getHeaderField("Content-Encoding"));
    }

    String getResponseEncoding(HttpConnection connection) {
        String charset = null;
        String contentType = connection.getHeaderField("Content-Type");
        if (contentType != null) {
            for (String param : contentType.replace(" ", "").split(";")) {
                if (!param.startsWith("charset=")) continue;
                charset = param.split("=", 2)[1];
                break;
            }
        }
        return charset;
    }

    private static void preconditionNotNull(Object what, String message) {
        if (what == null) {
            throw new NullPointerException(message);
        }
    }

    private String truncate(String toTruncate, int maxLen) {
        if (toTruncate == null) {
            return null;
        }
        if (toTruncate.length() <= maxLen) {
            return toTruncate;
        }
        return toTruncate.substring(0, maxLen);
    }
}

