/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.security;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.security.AuthenticationType;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

abstract class CommonAuthenticator
implements Valid {
    private Logger log;
    private AuthenticationType authenticationType;
    private String realm;

    CommonAuthenticator(Logger log, AuthenticationType authenticationType) {
        this.log = log;
        this.authenticationType = authenticationType;
        this.realm = "Charon security";
    }

    @Override
    public void validate() {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.realm), (String)"No authentication realm set");
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.AUTHENTICATOR;
    }

    Logger getLog() {
        return this.log;
    }

    void setRealm(String realm) {
        this.realm = realm;
    }

    HttpStatus getAuthenticationFailureResponseStatus() {
        return HttpStatus.UNAUTHORIZED;
    }

    String extractCredentials(HttpHeaders requestHeaders) {
        String authorization = requestHeaders.getFirst("Authorization");
        if (StringUtils.isBlank((CharSequence)authorization)) {
            return null;
        }
        return StringUtils.removeStartIgnoreCase((String)authorization.trim(), (String)this.authenticationType.toString()).trim();
    }

    void setAuthenticationInformation(HttpHeaders responseHeaders, Consumer<HttpHeaders> responseHeadersSetter) {
        HttpHeaders rewrittenHeaders = Utils.copyHeaders(responseHeaders);
        rewrittenHeaders.set("WWW-Authenticate", this.authenticationType + " realm=\"" + this.realm + "\"");
        responseHeadersSetter.accept(rewrittenHeaders);
        this.log.debug("Authentication failed, response headers rewritten from {} to {}", (Object)responseHeaders, (Object)rewrittenHeaders);
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] {} authentication for '{}' request mapping", (Object)this.authenticationType, (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] {} authentication for '{}' request mapping", (Object)this.authenticationType, (Object)mappingName);
    }
}

