/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.security;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.security.AuthenticationType;
import com.github.mkopylec.charon.forwarding.interceptors.security.CommonAuthenticator;
import com.github.mkopylec.charon.forwarding.interceptors.security.CredentialsValidator;
import org.slf4j.Logger;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;

abstract class Authenticator<V extends CredentialsValidator>
extends CommonAuthenticator
implements RequestForwardingInterceptor {
    private V credentialsValidator;

    Authenticator(Logger log, AuthenticationType authenticationType) {
        super(log, authenticationType);
    }

    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        this.logStart(execution.getMappingName());
        String credentials = this.extractCredentials(request.getHeaders());
        if (credentials == null) {
            return this.getFailedAuthenticationResponse();
        }
        boolean authenticated = this.credentialsValidator.validate(credentials);
        if (!authenticated) {
            return this.getFailedAuthenticationResponse();
        }
        this.getLog().debug("Authentication successful");
        HttpResponse response = execution.execute(request);
        this.logEnd(execution.getMappingName());
        return response;
    }

    @Override
    public void validate() {
        Assert.notNull(this.credentialsValidator, (String)"No credentials validator set");
        this.credentialsValidator.validate();
        super.validate();
    }

    void setCredentialsValidator(V credentialsValidator) {
        this.credentialsValidator = credentialsValidator;
    }

    private HttpResponse getFailedAuthenticationResponse() {
        HttpResponse response = new HttpResponse((HttpStatusCode)this.getAuthenticationFailureResponseStatus());
        this.setAuthenticationInformation(response.getHeaders(), response::setHeaders);
        return response;
    }
}

