/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.CommonRootPathResponseCookiesRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RootPathResponseCookiesRewriter
extends CommonRootPathResponseCookiesRewriter
implements RequestForwardingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RootPathResponseCookiesRewriter.class);

    RootPathResponseCookiesRewriter() {
        super(log);
    }

    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        this.logStart(execution.getMappingName());
        HttpResponse response = execution.execute(request);
        this.rewriteCookies(response.getHeaders(), "Set-Cookie", response::setHeaders);
        this.rewriteCookies(response.getHeaders(), "Set-Cookie2", response::setHeaders);
        this.logEnd(execution.getMappingName());
        return response;
    }
}

