/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.CommonRemovingResponseCookiesRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

class RemovingResponseCookiesRewriter
extends CommonRemovingResponseCookiesRewriter
implements RequestForwardingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RemovingResponseCookiesRewriter.class);

    RemovingResponseCookiesRewriter() {
        super(log);
    }

    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        this.logStart(execution.getMappingName());
        HttpResponse response = execution.execute(request);
        HttpHeaders headers = response.getHeaders();
        this.removeCookies(headers, "Set-Cookie", response::setHeaders);
        this.removeCookies(headers, "Set-Cookie2", response::setHeaders);
        this.logEnd(execution.getMappingName());
        return response;
    }
}

