/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PathTemplate {
    private static final Pattern placeholderSearchPattern = Pattern.compile("<([^>]*)");
    private String value;
    private List<String> placeholders = new ArrayList<String>();

    PathTemplate(String value) {
        this.value = value;
        this.findPlaceholders(value);
    }

    String fill(Matcher matcher) {
        String filledValue = this.value;
        for (String placeholder : this.placeholders) {
            String group = matcher.group(placeholder);
            filledValue = filledValue.replace("<" + placeholder + ">", group);
        }
        return filledValue;
    }

    private void findPlaceholders(String value) {
        Matcher matcher = placeholderSearchPattern.matcher(value);
        while (matcher.find()) {
            this.placeholders.add(matcher.group(1));
        }
    }

    public String toString() {
        return this.value;
    }
}

