/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import java.net.HttpCookie;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;

abstract class CommonRootPathResponseCookiesRewriter
implements Valid {
    private Logger log;

    CommonRootPathResponseCookiesRewriter(Logger log) {
        this.log = log;
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.RESPONSE_COOKIE_REWRITER;
    }

    void rewriteCookies(HttpHeaders headers, String cookieHeaderName, Consumer<HttpHeaders> headersSetter) {
        HttpHeaders rewrittenHeaders = Utils.copyHeaders(headers);
        List responseCookies = (List)rewrittenHeaders.getOrDefault((Object)cookieHeaderName, Collections.emptyList());
        List rewrittenResponseCookies = responseCookies.stream().map(this::replaceCookiePath).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(rewrittenResponseCookies)) {
            rewrittenHeaders.put(cookieHeaderName, rewrittenResponseCookies);
            headersSetter.accept(rewrittenHeaders);
            this.log.debug("Response cookies rewritten from {} to {}", (Object)responseCookies, rewrittenResponseCookies);
        }
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Root path response cookies rewriting for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Root path response cookies rewriting for '{}' request mapping", (Object)mappingName);
    }

    private String replaceCookiePath(String setCookieHeader) {
        if (StringUtils.isBlank((CharSequence)setCookieHeader)) {
            return setCookieHeader;
        }
        List<HttpCookie> cookies = HttpCookie.parse(setCookieHeader);
        if (CollectionUtils.isEmpty(cookies)) {
            return setCookieHeader;
        }
        String path = cookies.get(0).getPath();
        if (path == null) {
            return setCookieHeader + "; Path=/";
        }
        return setCookieHeader.replace("Path=" + path, "Path=/");
    }
}

