/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;

abstract class CommonResponseProtocolHeadersRewriter
implements Valid {
    private static final String PUBLIC_KEY_PINS = "Public-Key-Pins";
    private static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
    private Logger log;

    CommonResponseProtocolHeadersRewriter(Logger log) {
        this.log = log;
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.RESPONSE_PROTOCOL_HEADERS_REWRITER;
    }

    void rewriteHeaders(HttpHeaders headers, Consumer<HttpHeaders> headersSetter) {
        HttpHeaders rewrittenHeaders = Utils.copyHeaders(headers);
        rewrittenHeaders.remove((Object)"Transfer-Encoding");
        rewrittenHeaders.remove((Object)"Connection");
        rewrittenHeaders.remove((Object)PUBLIC_KEY_PINS);
        rewrittenHeaders.remove((Object)"Server");
        rewrittenHeaders.remove((Object)STRICT_TRANSPORT_SECURITY);
        headersSetter.accept(rewrittenHeaders);
        this.log.debug("Response headers rewritten from {} to {}", (Object)headers, (Object)rewrittenHeaders);
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Response protocol headers rewriting for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Response protocol headers rewriting for '{}' request mapping", (Object)mappingName);
    }
}

