/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.BodilessHttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.LoadBalancer;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.RandomLoadBalancerConfigurer;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

abstract class CommonRequestServerNameRewriter
implements Valid {
    private static final Pattern outgoingServerPattern = Pattern.compile("\\w+://.+");
    private Logger log;
    private LoadBalancer loadBalancer;
    private List<URI> outgoingServers;

    CommonRequestServerNameRewriter(Logger log) {
        this.log = log;
        this.loadBalancer = RandomLoadBalancerConfigurer.randomLoadBalancer().configure();
    }

    @Override
    public void validate() {
        this.loadBalancer.validate();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(this.outgoingServers), (String)"No outgoing servers set");
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.REQUEST_SERVER_NAME_REWRITER;
    }

    void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    void setOutgoingServers(List<String> outgoingServers) {
        this.outgoingServers = outgoingServers.stream().map(server -> outgoingServerPattern.matcher((CharSequence)server).matches() ? server : "http://" + server).map(URI::create).collect(Collectors.toList());
    }

    void rewriteServerName(BodilessHttpRequest request, Consumer<URI> rewrittenUriSetter) {
        URI rewrittenServerName = this.loadBalancer.chooseServer(this.outgoingServers, request);
        URI rewrittenUri = UriComponentsBuilder.fromUri((URI)request.getUrl()).scheme(rewrittenServerName.getScheme()).host(rewrittenServerName.getHost()).port(rewrittenServerName.getPort()).build(true).toUri();
        rewrittenUriSetter.accept(rewrittenUri);
        this.log.debug("Request server name rewritten from {} to {}", (Object)request.getServerName(), (Object)rewrittenServerName);
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Request server name rewriting for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Request server name rewriting for '{}' request mapping", (Object)mappingName);
    }
}

