/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;

abstract class CommonRequestProxyHeadersRewriter
implements Valid {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    private static final String X_FORWARDED_PORT = "X-Forwarded-Port";
    private Logger log;

    CommonRequestProxyHeadersRewriter(Logger log) {
        this.log = log;
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.REQUEST_PROXY_HEADERS_REWRITER;
    }

    void rewriteHeaders(HttpHeaders headers, URI uri, Consumer<HttpHeaders> headersSetter) {
        HttpHeaders rewrittenHeaders = Utils.copyHeaders(headers);
        ArrayList<String> forwardedFor = new ArrayList<String>(CollectionUtils.emptyIfNull((Collection)rewrittenHeaders.get((Object)X_FORWARDED_FOR)));
        forwardedFor.add(uri.getAuthority());
        rewrittenHeaders.put(X_FORWARDED_FOR, forwardedFor);
        rewrittenHeaders.set(X_FORWARDED_PROTO, uri.getScheme());
        rewrittenHeaders.set(X_FORWARDED_HOST, uri.getHost());
        rewrittenHeaders.set(X_FORWARDED_PORT, this.resolvePort(uri));
        headersSetter.accept(rewrittenHeaders);
        this.log.debug("Request headers rewritten from {} to {}", (Object)headers, (Object)rewrittenHeaders);
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Request proxy headers rewriting for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Request proxy headers rewriting for '{}' request mapping", (Object)mappingName);
    }

    private String resolvePort(URI uri) {
        int port = uri.getPort();
        if (port < 0) {
            port = uri.getScheme().equals("https") ? 443 : 80;
        }
        return String.valueOf(port);
    }
}

