/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;

abstract class CommonRequestProtocolHeadersRewriter
implements Valid {
    private Logger log;

    CommonRequestProtocolHeadersRewriter(Logger log) {
        this.log = log;
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.REQUEST_PROTOCOL_HEADERS_REWRITER;
    }

    void rewriteHeaders(HttpHeaders headers, Consumer<HttpHeaders> headersSetter) {
        HttpHeaders rewrittenHeaders = Utils.copyHeaders(headers);
        rewrittenHeaders.set("Connection", "close");
        rewrittenHeaders.remove((Object)"TE");
        headersSetter.accept(rewrittenHeaders);
        this.log.debug("Request headers rewritten from {} to {}", (Object)headers, (Object)rewrittenHeaders);
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Request protocol headers rewriting for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Request protocol headers rewriting for '{}' request mapping", (Object)mappingName);
    }
}

