/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import java.net.URI;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;

abstract class CommonRequestHostHeaderRewriter
implements Valid {
    private Logger log;

    CommonRequestHostHeaderRewriter(Logger log) {
        this.log = log;
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.REQUEST_HOST_HEADER_REWRITER;
    }

    void rewriteHeaders(HttpHeaders headers, URI uri, Consumer<HttpHeaders> headersSetter) {
        HttpHeaders rewrittenHeaders = Utils.copyHeaders(headers);
        rewrittenHeaders.set("Host", uri.getAuthority());
        headersSetter.accept(rewrittenHeaders);
        this.log.debug("Request headers rewritten from {} to {}", (Object)headers, (Object)rewrittenHeaders);
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Request 'Host' header rewriting for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Request 'Host' header rewriting for '{}' request mapping", (Object)mappingName);
    }
}

