/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;

abstract class CommonRemovingResponseCookiesRewriter
implements Valid {
    private Logger log;

    CommonRemovingResponseCookiesRewriter(Logger log) {
        this.log = log;
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.RESPONSE_COOKIE_REWRITER;
    }

    void removeCookies(HttpHeaders headers, String cookieHeaderName, Consumer<HttpHeaders> headersSetter) {
        HttpHeaders rewrittenHeaders = Utils.copyHeaders(headers);
        List removedCookies = rewrittenHeaders.remove((Object)cookieHeaderName);
        if (CollectionUtils.isNotEmpty((Collection)removedCookies)) {
            headersSetter.accept(rewrittenHeaders);
            this.log.debug("Cookies {} removed from response", (Object)removedCookies);
        }
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Removing response cookies for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Removing response cookies for '{}' request mapping", (Object)mappingName);
    }
}

