/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.rewrite;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.RequestForwardingException;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.PathTemplate;
import java.net.URI;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.springframework.web.util.UriComponentsBuilder;

abstract class CommonRegexRequestPathRewriter
implements Valid {
    private Logger log;
    private Pattern incomingRequestPathRegex;
    private PathTemplate outgoingRequestPathTemplate;

    CommonRegexRequestPathRewriter(Logger log) {
        this.log = log;
        this.incomingRequestPathRegex = Pattern.compile("/(?<path>.*)");
        this.outgoingRequestPathTemplate = new PathTemplate("/<path>");
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.REQUEST_PATH_REWRITER;
    }

    void setPaths(String incomingRequestPathRegex, String outgoingRequestPathTemplate) {
        this.incomingRequestPathRegex = Pattern.compile(incomingRequestPathRegex);
        this.outgoingRequestPathTemplate = new PathTemplate(outgoingRequestPathTemplate);
    }

    void rewritePath(URI uri, Consumer<URI> rewrittenUriSetter) {
        String rewrittenPath;
        String requestPath = uri.getRawPath();
        Matcher matcher = this.incomingRequestPathRegex.matcher(requestPath);
        RequestForwardingException.requestForwardingErrorIf(!matcher.find(), () -> "Incoming request path " + requestPath + " does not match path rewriter regex pattern " + this.incomingRequestPathRegex);
        try {
            rewrittenPath = this.outgoingRequestPathTemplate.fill(matcher);
        }
        catch (IllegalArgumentException e) {
            throw RequestForwardingException.requestForwardingError("Path rewriter regex pattern " + this.incomingRequestPathRegex + " does not contain groups required to fill request path template " + this.outgoingRequestPathTemplate, e);
        }
        URI rewrittenUri = UriComponentsBuilder.fromUri((URI)uri).replacePath(rewrittenPath).build(true).toUri();
        rewrittenUriSetter.accept(rewrittenUri);
        this.log.debug("Request path rewritten from {} to {}", (Object)requestPath, (Object)rewrittenPath);
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Regex request path rewriting for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Regex request path rewriting for '{}' request mapping", (Object)mappingName);
    }
}

