/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

class RetryingState {
    private static ThreadLocal<State> state = new ThreadLocal();

    RetryingState() {
    }

    static State getRetryState() {
        if (state.get() == null) {
            state.set(new State());
        }
        return state.get();
    }

    static void clearRetryState() {
        state.remove();
    }

    static class State {
        private int retryAttempts;
        private boolean firstAttempt;
        private boolean nextAttempt;
        private Integer afterRetryerIndex;

        State() {
        }

        boolean isFirstRetryAttempt() {
            return this.retryAttempts == 1 && this.firstAttempt;
        }

        void firstRetryAttemptApplied() {
            this.firstAttempt = false;
        }

        boolean isSucceedingRetryAttempt() {
            return this.retryAttempts > 1 && this.nextAttempt && this.afterRetryerIndex != null;
        }

        void succeedingRetryAttemptApplied() {
            this.nextAttempt = false;
        }

        int getAfterRetryerIndex() {
            return this.afterRetryerIndex;
        }

        void setAfterRetryerIndex(int index) {
            this.afterRetryerIndex = index;
        }

        void nextRetryAttempt() {
            ++this.retryAttempts;
            if (this.retryAttempts == 1) {
                this.firstAttempt = true;
            }
            this.nextAttempt = true;
        }
    }
}

