/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.resilience.CommonRetryer;
import com.github.mkopylec.charon.forwarding.interceptors.resilience.RetryingState;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Retryer
extends CommonRetryer<HttpResponse>
implements RequestForwardingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(Retryer.class);

    Retryer() {
        super((R response) -> response.getStatusCode().is5xxServerError(), log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        HttpResponse response;
        this.logStart(execution.getMappingName());
        Retry retry = ((RetryRegistry)this.getRegistry()).retry(execution.getMappingName());
        this.setupMetrics(registry -> this.createMetrics((RetryRegistry)registry, execution.getMappingName()));
        try {
            response = (HttpResponse)retry.executeSupplier(() -> {
                RetryingState.getRetryState().nextRetryAttempt();
                HttpResponse httpResponse = execution.execute(request);
                httpResponse.close();
                return httpResponse;
            });
        }
        finally {
            RetryingState.clearRetryState();
        }
        this.logEnd(execution.getMappingName());
        return response;
    }
}

