/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

import com.github.mkopylec.charon.forwarding.interceptors.resilience.RetryingState;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public class RetryAwareList<E>
extends ArrayList<E> {
    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    static /* synthetic */ int access$000(RetryAwareList x0) {
        return x0.modCount;
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount = RetryAwareList.access$000(RetryAwareList.this);

        Itr() {
        }

        @Override
        public boolean hasNext() {
            this.cursor = this.resolveCursorForSucceedingRetryAttempt(this.cursor);
            return this.cursor != RetryAwareList.this.size();
        }

        @Override
        public E next() {
            this.handleFirstRetryAttempt(this.cursor);
            this.cursor = this.resolveCursorForSucceedingRetryAttempt(this.cursor);
            this.checkForComodification();
            int i = this.cursor;
            if (i >= RetryAwareList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] elementData = RetryAwareList.this.toArray();
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                RetryAwareList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = RetryAwareList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            int size = RetryAwareList.this.size();
            if (i < size) {
                Object[] es = RetryAwareList.this.toArray();
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                for (i = this.cursor; i < size && RetryAwareList.this.modCount == this.expectedModCount; ++i) {
                    this.handleFirstRetryAttempt(i);
                    i = this.resolveCursorForSucceedingRetryAttempt(i);
                    action.accept(es[i]);
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (RetryAwareList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void handleFirstRetryAttempt(int cursor) {
            if (RetryingState.getRetryState().isFirstRetryAttempt()) {
                RetryingState.getRetryState().setAfterRetryerIndex(cursor);
                RetryingState.getRetryState().firstRetryAttemptApplied();
            }
        }

        private int resolveCursorForSucceedingRetryAttempt(int cursor) {
            if (RetryingState.getRetryState().isSucceedingRetryAttempt()) {
                cursor = RetryingState.getRetryState().getAfterRetryerIndex();
                RetryingState.getRetryState().succeedingRetryAttemptApplied();
            }
            return cursor;
        }
    }
}

