/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.resilience.CommonRateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RateLimiter
extends CommonRateLimiter
implements RequestForwardingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RateLimiter.class);

    RateLimiter() {
        super(log);
    }

    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        this.logStart(execution.getMappingName());
        io.github.resilience4j.ratelimiter.RateLimiter rateLimiter = ((RateLimiterRegistry)this.getRegistry()).rateLimiter(execution.getMappingName());
        this.setupMetrics(registry -> this.createMetrics((RateLimiterRegistry)registry, execution.getMappingName()));
        HttpResponse response = (HttpResponse)rateLimiter.executeSupplier(() -> execution.execute(request));
        this.logEnd(execution.getMappingName());
        return response;
    }
}

