/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.resilience.CommonResilienceHandler;
import io.github.resilience4j.micrometer.tagged.RetryMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedRetryMetrics;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.time.Duration;
import java.util.function.Predicate;
import org.slf4j.Logger;

abstract class CommonRetryer<R>
extends CommonResilienceHandler<RetryRegistry>
implements Valid {
    private static final String RETRYING_METRICS_NAME = "retrying";

    CommonRetryer(Predicate<R> retryOnResult, Logger log) {
        super(log, RetryRegistry.of((RetryConfig)RetryConfig.custom().waitDuration(Duration.ZERO).retryOnResult(retryOnResult).retryExceptions(new Class[]{Throwable.class}).build()));
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.RETRYING_HANDLER;
    }

    TaggedRetryMetrics createMetrics(RetryRegistry registry, String mappingName) {
        String callsMetricName = Utils.metricName(mappingName, RETRYING_METRICS_NAME, "calls");
        RetryMetricNames metricNames = RetryMetricNames.custom().callsMetricName(callsMetricName).build();
        return TaggedRetryMetrics.ofRetryRegistry((RetryMetricNames)metricNames, (RetryRegistry)registry);
    }

    void logStart(String mappingName) {
        this.getLog().trace("[Start] Retrying of '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.getLog().trace("[End] Retrying of '{}' request mapping", (Object)mappingName);
    }
}

