/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.function.Function;
import org.slf4j.Logger;

abstract class CommonResilienceHandler<R> {
    private Logger log;
    private R registry;
    private MeterBinder metrics;
    private MeterRegistry meterRegistry;

    CommonResilienceHandler(Logger log, R registry) {
        this.log = log;
        this.registry = registry;
    }

    Logger getLog() {
        return this.log;
    }

    R getRegistry() {
        return this.registry;
    }

    void setRegistry(R registry) {
        this.registry = registry;
    }

    void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    void setupMetrics(Function<R, ? extends MeterBinder> metricsCreator) {
        if (this.meterRegistry == null) {
            return;
        }
        if (this.metrics == null) {
            this.metrics = metricsCreator.apply(this.registry);
            this.metrics.bindTo(this.meterRegistry);
        }
    }
}

