/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.resilience.CommonResilienceHandler;
import io.github.resilience4j.micrometer.tagged.RateLimiterMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedRateLimiterMetrics;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.time.Duration;
import org.slf4j.Logger;

abstract class CommonRateLimiter
extends CommonResilienceHandler<RateLimiterRegistry>
implements Valid {
    private static final String RATE_LIMITING_METRICS_NAME = "rate-limiting";

    CommonRateLimiter(Logger log) {
        super(log, RateLimiterRegistry.of((RateLimiterConfig)RateLimiterConfig.custom().timeoutDuration(Duration.ZERO).limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(100).build()));
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.RATE_LIMITING_HANDLER;
    }

    TaggedRateLimiterMetrics createMetrics(RateLimiterRegistry registry, String mappingName) {
        String availablePermissionsMetricName = Utils.metricName(mappingName, RATE_LIMITING_METRICS_NAME, "available-permissions");
        String waitingThreadsMetricName = Utils.metricName(mappingName, RATE_LIMITING_METRICS_NAME, "waiting-threads");
        RateLimiterMetricNames metricNames = RateLimiterMetricNames.custom().availablePermissionsMetricName(availablePermissionsMetricName).waitingThreadsMetricName(waitingThreadsMetricName).build();
        return TaggedRateLimiterMetrics.ofRateLimiterRegistry((RateLimiterMetricNames)metricNames, (RateLimiterRegistry)registry);
    }

    void logStart(String mappingName) {
        this.getLog().trace("[Start] Rate limiting of '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.getLog().trace("[End] Rate limiting of '{}' request mapping", (Object)mappingName);
    }
}

