/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.resilience.CommonResilienceHandler;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.CircuitBreakerMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;

abstract class CommonCircuitBreaker<R>
extends CommonResilienceHandler<CircuitBreakerRegistry>
implements Valid {
    private static final String CIRCUIT_BREAKER_METRICS_NAME = "circuit-breaking";
    private Function<CallNotPermittedException, R> fallback;

    CommonCircuitBreaker(Predicate<R> failOnResult, Logger log) {
        super(log, CircuitBreakerRegistry.of((CircuitBreakerConfig)CircuitBreakerConfig.custom().recordResult(result -> failOnResult.test(result)).recordExceptions(new Class[]{Throwable.class}).build()));
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.CIRCUIT_BREAKER_HANDLER;
    }

    void setFallback(Function<CallNotPermittedException, R> fallback) {
        this.fallback = fallback;
    }

    TaggedCircuitBreakerMetrics createMetrics(CircuitBreakerRegistry registry, String mappingName) {
        String bufferedCallsMetricName = Utils.metricName(mappingName, CIRCUIT_BREAKER_METRICS_NAME, "buffered-calls");
        String callsMetricName = Utils.metricName(mappingName, CIRCUIT_BREAKER_METRICS_NAME, "calls");
        String stateMetricName = Utils.metricName(mappingName, CIRCUIT_BREAKER_METRICS_NAME, "state");
        String failureRateMetricName = Utils.metricName(mappingName, CIRCUIT_BREAKER_METRICS_NAME, "failure-rate");
        String slowCallRateMetricName = Utils.metricName(mappingName, CIRCUIT_BREAKER_METRICS_NAME, "slow-calls-rate");
        String slowCallsMetricName = Utils.metricName(mappingName, CIRCUIT_BREAKER_METRICS_NAME, "slow-calls");
        CircuitBreakerMetricNames metricNames = CircuitBreakerMetricNames.custom().bufferedCallsMetricName(bufferedCallsMetricName).callsMetricName(callsMetricName).stateMetricName(stateMetricName).failureRateMetricName(failureRateMetricName).slowCallRateMetricName(slowCallRateMetricName).slowCallsMetricName(slowCallsMetricName).build();
        return TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerMetricNames)metricNames, (CircuitBreakerRegistry)registry);
    }

    R executeFallback(CallNotPermittedException ex) {
        if (this.fallback == null) {
            throw ex;
        }
        this.getLog().debug("Circuit breaker call not permitted, executing fallback");
        return this.fallback.apply(ex);
    }

    void logStart(String mappingName) {
        this.getLog().trace("[Start] Circuit breaker for '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.getLog().trace("[End] Circuit breaker for '{}' request mapping", (Object)mappingName);
    }
}

