/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.resilience;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.resilience.CommonCircuitBreaker;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CircuitBreaker
extends CommonCircuitBreaker<HttpResponse>
implements RequestForwardingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CircuitBreaker.class);

    CircuitBreaker() {
        super((R response) -> response.getStatusCode().is5xxServerError(), log);
    }

    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        HttpResponse response;
        this.logStart(execution.getMappingName());
        io.github.resilience4j.circuitbreaker.CircuitBreaker circuitBreaker = ((CircuitBreakerRegistry)this.getRegistry()).circuitBreaker(execution.getMappingName());
        this.setupMetrics(registry -> this.createMetrics((CircuitBreakerRegistry)registry, execution.getMappingName()));
        try {
            response = (HttpResponse)circuitBreaker.executeSupplier(() -> execution.execute(request));
        }
        catch (CallNotPermittedException ex) {
            response = (HttpResponse)this.executeFallback(ex);
        }
        this.logEnd(execution.getMappingName());
        return response;
    }
}

