/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.metrics;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.metrics.CommonRateMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RateMeter
extends CommonRateMeter
implements RequestForwardingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RateMeter.class);

    RateMeter() {
        super(log);
    }

    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        this.logStart(execution.getMappingName());
        try {
            HttpResponse response = execution.execute(request);
            this.captureResponseStatusMetric(execution.getMappingName(), response.getStatusCode());
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (RuntimeException ex) {
            this.captureExceptionMetric(execution.getMappingName(), ex);
            throw ex;
        }
        finally {
            this.logEnd(execution.getMappingName());
        }
    }
}

