/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.metrics;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.metrics.CommonLatencyMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LatencyMeter
extends CommonLatencyMeter
implements RequestForwardingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LatencyMeter.class);

    LatencyMeter() {
        super(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        this.logStart(execution.getMappingName());
        long startingTime = System.nanoTime();
        try {
            HttpResponse httpResponse = execution.execute(request);
            return httpResponse;
        }
        finally {
            this.captureLatencyMetric(execution.getMappingName(), startingTime);
            this.logEnd(execution.getMappingName());
        }
    }
}

