/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.metrics;

import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.metrics.CommonMeter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpStatusCode;

abstract class CommonRateMeter
extends CommonMeter {
    CommonRateMeter(Logger log) {
        super(log);
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.RATE_METER;
    }

    void captureResponseStatusMetric(String mappingName, HttpStatusCode responseStatus) {
        String metricName = Utils.metricName(mappingName, "response", "status", String.valueOf(responseStatus.value()));
        this.getMeterRegistry().counter(metricName, new String[0]).increment();
    }

    void captureExceptionMetric(String mappingName, Throwable ex) {
        String exception = ExceptionUtils.getRootCause((Throwable)ex).getClass().getSimpleName().toLowerCase();
        String metricName = Utils.metricName(mappingName, "response", "exception", exception);
        this.getMeterRegistry().counter(metricName, new String[0]).increment();
    }

    void logStart(String mappingName) {
        this.getLog().trace("[Start] Collect rate metrics of '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.getLog().trace("[End] Collect rate metrics of '{}' request mapping", (Object)mappingName);
    }
}

