/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.metrics;

import com.github.mkopylec.charon.forwarding.Utils;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.metrics.CommonMeter;
import java.time.Duration;
import org.slf4j.Logger;

abstract class CommonLatencyMeter
extends CommonMeter {
    CommonLatencyMeter(Logger log) {
        super(log);
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.LATENCY_METER;
    }

    void captureLatencyMetric(String mappingName, long startingTime) {
        String metricName = Utils.metricName(mappingName, "latency");
        Duration responseTime = Duration.ofNanos(System.nanoTime() - startingTime);
        this.getMeterRegistry().timer(metricName, new String[0]).record(responseTime);
    }

    void logStart(String mappingName) {
        this.getLog().trace("[Start] Collect latency metrics of '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.getLog().trace("[End] Collect latency metrics of '{}' request mapping", (Object)mappingName);
    }
}

