/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.log;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.log.LogLevel;
import java.net.URI;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;

abstract class CommonForwardingLogger
implements Valid {
    private Logger log;
    private LogLevel successLogLevel;
    private LogLevel clientErrorLogLevel;
    private LogLevel serverErrorLogLevel;
    private LogLevel unexpectedErrorLogLevel;

    CommonForwardingLogger(Logger log) {
        this.log = log;
        this.successLogLevel = LogLevel.DEBUG;
        this.clientErrorLogLevel = LogLevel.INFO;
        this.serverErrorLogLevel = LogLevel.ERROR;
        this.unexpectedErrorLogLevel = LogLevel.ERROR;
    }

    @Override
    public void validate() {
        Assert.notNull((Object)((Object)this.successLogLevel), (String)"No success log level set");
        Assert.notNull((Object)((Object)this.clientErrorLogLevel), (String)"No client error log level set");
        Assert.notNull((Object)((Object)this.serverErrorLogLevel), (String)"No server error log level set");
        Assert.notNull((Object)((Object)this.unexpectedErrorLogLevel), (String)"No unexpected error log level set");
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.FORWARDING_LOGGER;
    }

    void setSuccessLogLevel(LogLevel successLogLevel) {
        this.successLogLevel = successLogLevel;
    }

    void setClientErrorLogLevel(LogLevel clientErrorLogLevel) {
        this.clientErrorLogLevel = clientErrorLogLevel;
    }

    void setServerErrorLogLevel(LogLevel serverErrorLogLevel) {
        this.serverErrorLogLevel = serverErrorLogLevel;
    }

    void setUnexpectedErrorLogLevel(LogLevel unexpectedErrorLogLevel) {
        this.unexpectedErrorLogLevel = unexpectedErrorLogLevel;
    }

    void logForwardingResult(HttpStatusCode responseStatus, HttpMethod originalRequestMethod, HttpMethod forwardedRequestMethod, URI originalRequestUri, URI forwardedRequestUri, String mappingName) {
        String logMessage = "Forwarding: {} {} -> '{}' -> {} {} {}";
        if (responseStatus.is5xxServerError()) {
            this.log(this.serverErrorLogLevel, logMessage, originalRequestMethod, originalRequestUri, mappingName, forwardedRequestMethod, forwardedRequestUri, responseStatus.value());
        } else if (responseStatus.is4xxClientError()) {
            this.log(this.clientErrorLogLevel, logMessage, originalRequestMethod, originalRequestUri, mappingName, forwardedRequestMethod, forwardedRequestUri, responseStatus.value());
        } else {
            this.log(this.successLogLevel, logMessage, originalRequestMethod, originalRequestUri, mappingName, forwardedRequestMethod, forwardedRequestUri, responseStatus.value());
        }
    }

    void logForwardingError(RuntimeException e, HttpMethod originalRequestMethod, URI originalRequestUri, String mappingName) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        this.log(this.unexpectedErrorLogLevel, "Forwarding: {} {} -> '{}' -> {}: {}", originalRequestMethod, originalRequestUri, mappingName, cause.getClass().getName(), cause.getMessage());
    }

    private void log(LogLevel level, String message, Object ... parameters) {
        switch (level) {
            case ERROR: {
                this.log.error(message, parameters);
                break;
            }
            case WARN: {
                this.log.warn(message, parameters);
                break;
            }
            case INFO: {
                this.log.info(message, parameters);
                break;
            }
            case DEBUG: {
                this.log.debug(message, parameters);
                break;
            }
            case TRACE: {
                this.log.trace(message, parameters);
            }
        }
    }
}

