/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.async;

import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.async.ThreadPool;
import com.github.mkopylec.charon.forwarding.interceptors.async.ThreadPoolConfigurer;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

abstract class CommonAsynchronousForwarder
implements Valid {
    private Logger log;
    private ThreadPool threadPool;

    CommonAsynchronousForwarder(Logger log) {
        this.log = log;
        this.threadPool = ThreadPoolConfigurer.threadPool().configure();
    }

    public RequestForwardingInterceptorType getType() {
        return RequestForwardingInterceptorType.ASYNCHRONOUS_FORWARDING_HANDLER;
    }

    ThreadPool getThreadPool() {
        return this.threadPool;
    }

    void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    HttpStatusCode getResponseStatus() {
        return HttpStatus.ACCEPTED;
    }

    void logForwardingResult(HttpStatusCode responseStatus, String mappingName) {
        String logMessage = "Asynchronous execution of '{}' request mapping resulted in {} response status";
        if (responseStatus.is5xxServerError()) {
            this.log.error(logMessage, (Object)mappingName, (Object)responseStatus.value());
        } else if (responseStatus.is4xxClientError()) {
            this.log.info(logMessage, (Object)mappingName, (Object)responseStatus.value());
        } else {
            this.log.debug(logMessage, (Object)mappingName, (Object)responseStatus.value());
        }
    }

    void logStart(String mappingName) {
        this.log.trace("[Start] Asynchronous execution of '{}' request mapping", (Object)mappingName);
    }

    void logEnd(String mappingName) {
        this.log.trace("[End] Asynchronous execution of '{}' request mapping", (Object)mappingName);
    }

    void logError(String mappingName, Exception e) {
        this.log.error("Error executing '{}' request mapping asynchronously", (Object)mappingName, (Object)e);
    }
}

