/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors.async;

import com.github.mkopylec.charon.forwarding.interceptors.HttpRequest;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestExecution;
import com.github.mkopylec.charon.forwarding.interceptors.HttpResponse;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.async.CommonAsynchronousForwarder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsynchronousForwarder
extends CommonAsynchronousForwarder
implements RequestForwardingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousForwarder.class);

    AsynchronousForwarder() {
        super(log);
    }

    @Override
    public HttpResponse forward(HttpRequest request, HttpRequestExecution execution) {
        this.getThreadPool().execute(() -> this.forwardAsynchronously(request, execution));
        return new HttpResponse(this.getResponseStatus());
    }

    private void forwardAsynchronously(HttpRequest request, HttpRequestExecution execution) {
        this.logStart(execution.getMappingName());
        try {
            HttpResponse response = execution.execute(request);
            this.logForwardingResult(response.getStatusCode(), execution.getMappingName());
        }
        catch (Exception e) {
            this.logError(execution.getMappingName(), e);
        }
        this.logEnd(execution.getMappingName());
    }
}

